import { Card, } from '@material-ui/core';
import React from 'react';
import useStyles from './styles';
import { ICarInfo } from './index';

declare let ymaps;
export default function ({carInfo}: {carInfo: ICarInfo | null}) {
    const classes = useStyles();
    let myMap: any = null;

    React.useEffect(() => {
        ymaps.ready(function () {
            let {locations = []} = carInfo ?? {};
            let location = locations.find(location => location.type === 'GPSCurrent') ?? locations[0] ?? null;

            if (location?.latitude && location?.longitude) {
                let carLocation = [location.latitude, location.longitude];

                let vectorConfig = {
                    vector: true,
                    layerVectorRevealThreshold: 0,
                };
                myMap = new ymaps.Map('map', {
                    center: carLocation,
                    zoom: 14
                }, {
                    ...vectorConfig
                });
                let myPlacemark = new ymaps.Placemark(carLocation, {},
                    {
                        preset: 'islands#circleDotIcon'
                    }
                );
                myMap?.geoObjects?.add?.(myPlacemark);
            }
        });
        return () => {
            myMap?.destroy();
        };
    }, [carInfo?.id]);

    return <Card className={classes.card}>
        {
            carInfo?.id && carInfo.locations === null
                ? 'нет данных о координах авто...'
                : <div id={'map'} className={`${classes.map}`}/>
        }
    </Card>;
}