import React from 'react';
import Header from '../Header';
import { Route, Switch, useHistory } from 'react-router-dom';
import ROUTS from '../../constants';

export default function Core() {
    let history = useHistory();
    const search = (e) => {
        let value = e.target.value;
        if (value.length) {
            history?.push(`/search/${value}`);
        } else {
            history?.push(`/`);
        }
    };
    return <React.Fragment>
        <Header search={search}/>
        <Switch>
            {
                Object.entries(ROUTS)?.map((el: any[]) => {
                    let Component = el[1].component;
                    return <Route path={el[1].path} key={el[0]}><Component/></Route>;
                })
            }
        </Switch>
    </React.Fragment>;
}