import Typography from '@material-ui/core/Typography';
import { Card } from '@material-ui/core';
import React from 'react';
import { createStyles, makeStyles } from '@material-ui/core/styles';

const useStyles = makeStyles(() =>
    createStyles({
        card: {
            marginTop: 5,
            marginBottom: 5,
            padding: 10
        },
    }),
);

export default function ErrorCard({error}) {
    const classes = useStyles();
    return <Card className={`${classes.card}`}>
        <Typography gutterBottom variant="h4" component="h2" color={'secondary'}>
            Ошибка {error?.error_details?.http_code || error?.status}
        </Typography>
        <Typography gutterBottom color={'secondary'}>
            {error?.error_details?.debug_message || error?.message || error?.error}
        </Typography>
    </Card>;
}