import {
    AppBar,
    Drawer,
    IconButton,
    InputBase,
    List,
    ListItem,
    ListItemText,
    Toolbar,
    Typography
} from '@material-ui/core';
import MenuIcon from '@material-ui/icons/Menu';
import SearchIcon from '@material-ui/icons/Search';
import React from 'react';
import useStyles from './styles';
import UserInfo from '../UserInfo';
import { useHistory, useLocation } from 'react-router-dom';
import ROUTS from '../../constants';

interface IHeader {
    search: (text) => void
}

export default function Header(props: IHeader) {
    const classes = useStyles();
    let [drawerIsOpen, open] = React.useState(false);
    let history = useHistory();
    let location = useLocation();

    const menuClick = (menu: string) => {
        history.push(menu);
    };

    return <>
        <AppBar position="static">
            <Toolbar>
                <IconButton
                    onClick={open.bind(null, true)}
                    edge="start"
                    className={classes.menuButton}
                    color="inherit"
                    aria-label="open drawer"
                >
                    <MenuIcon/>
                </IconButton>
                <Typography className={classes.title} variant="h6" noWrap align={'left'}>
                    Emergency Admin
                </Typography>

                <div className={classes.search}>
                    <div className={classes.searchIcon}>
                        <SearchIcon/>
                    </div>
                    <InputBase
                        onChange={props.search}
                        placeholder="Поиск авто..."
                        classes={{
                            root: classes.inputRoot,
                            input: classes.inputInput,
                        }}
                        inputProps={{'aria-label': 'search'}}
                    />
                </div>
            </Toolbar>
        </AppBar>
        <Drawer anchor={'left'} open={drawerIsOpen}
                onClose={open.bind(null, false)}>
            <div
                className={classes.list}
                role="presentation"
                onClick={open.bind(null, false)}
                onKeyDown={open.bind(null, false)}
            >

                <List>
                    <UserInfo/>
                    {
                        Object.entries(ROUTS)
                            ?.filter((el) => !el[1]?.ignoreMenu)
                            ?.sort((a, b) => (a[1]?.menuIndex || 0) - (b[1]?.menuIndex || 0))
                            ?.map((el) => {
                                return <ListItem button
                                                 selected={location.pathname === el[1].path}
                                                 onClick={menuClick.bind(null, el[1].path)} key={el[0]}>
                                    <ListItemText primary={el[1].menuTitle} secondary={el[1].description}/>
                                </ListItem>;
                            })
                    }
                </List>
            </div>
        </Drawer>
    </>;
}