import React from 'react';
import { createStyles, makeStyles, Theme } from '@material-ui/core/styles';
import Paper from '@material-ui/core/Paper';

const useStyles = makeStyles((theme: Theme) =>
    createStyles({
        root: {
            display: 'flex',
            flexWrap: 'wrap',
            color: theme.palette.secondary.light,
            '& > *': {
                margin: theme.spacing(1),
                width: theme.spacing(4),
                height: theme.spacing(16),
            },
        },
        paper: {
            padding: '25px',
            width: '100%',
            height: 'auto'
        },
        warning: {
            color: theme.palette.warning.dark
        }
    }),
);

export default function Home() {
    const classes = useStyles();

    return (
        <div className={classes.root}>
            <Paper elevation={3} className={classes.paper}>
                <h2> 🎃 Вы на страничке факапной админки, возможно, что-то случилось!</h2>
                <ul>
                    <li className={classes.warning}>Пока все запросы идут на тестинг</li>
                    <li>Тут можно будет найти машинки</li>
                    <li>Провести операции с телематикой</li>
                </ul>
            </Paper>
        </div>
    );
}