import React from 'react';
import { useHistory, useParams } from 'react-router-dom';
import useData from '../../hooks/useData';
import { Avatar, ListItem, ListItemAvatar, ListItemText } from '@material-ui/core';
import CarListSpinner from '../CarListSpinner';
import ErrorCard from '../ErrorCard';
import SearchIcon from '@material-ui/icons/Search';

const TIME_OUT = 300;

export function __deprecated_Search() {
    let {find_text} = useParams<{ find_text: string }>();
    let history = useHistory();
    let [{isLoading, data, error}, doFetch] = useData<any>();
    let timer;
    React.useEffect(() => {
        clearTimeout(timer);
        timer = setTimeout(() => {
            doFetch({url: `api/staff/search?has_all_of=${find_text}&limit=50&what=cars`});
        }, TIME_OUT);

        return () => {
            clearTimeout(timer);
        };
    }, [find_text]);

    const click = (car_id) => {
        history.push(`/cars/${car_id}/${find_text}`);
    };

    return <div>
        {
            error && <ErrorCard error={error}/>
        }
        {
            isLoading
                ? <CarListSpinner/>
                : data?.objects?.cars?.length
                ? data.objects.cars.map((car, index) => {

                    return <React.Fragment key={index}>
                        <ListItem button divider onClick={click.bind(null, car.id)}>
                            <ListItemAvatar>
                                <Avatar>
                                    {car.model_id?.[0]?.toUpperCase()}
                                </Avatar>
                            </ListItemAvatar>
                            <ListItemText primary={car.number} secondary={car.model_id}/>
                        </ListItem>
                    </React.Fragment>;
                }) : <ListItem divider>
                    <ListItemAvatar>
                        <Avatar>
                            <SearchIcon/>
                        </Avatar>
                    </ListItemAvatar>
                    <ListItemText primary={find_text} secondary={'Ничего не найдено 🤷'}/>
                </ListItem>
        }

    </div>;
}

const CARS_SEARCH_LIMIT = 50;

interface ISearchCarResult {
    number: string,
    imei: string,
    id: string
}

export default function Search() {
    let {prefix} = useParams<{ prefix: string }>();
    let history = useHistory();
    let [{isLoading, data, error}, doFetch] = useData<ISearchCarResult[]>(true);
    let timer;
    React.useEffect(() => {
        clearTimeout(timer);
        timer = setTimeout(() => {
            doFetch({
                url: `api/staff/car/search`,
                options: {method: 'POST', body: JSON.stringify({
                        prefix,
                        limit: CARS_SEARCH_LIMIT
                    })}
            });
        }, TIME_OUT);

        return () => {
            clearTimeout(timer);
        };
    }, [prefix]);

    const click = (carNumber: string) => {
        history.push(encodeURI(`/cars/${carNumber}/${prefix}`));
    };

    return <div>
        {
            error && <ErrorCard error={error}/>
        }
        {
            isLoading
                ? <CarListSpinner/>
                : data?.length
                ? data?.map(car => {
                    let {imei, id, number} = car;

                    return <React.Fragment key={id}>
                        {<ListItem button divider onClick={click.bind(null, number)}>
                            <ListItemAvatar>
                                <Avatar>
                                    {number?.[0]?.toUpperCase()}
                                </Avatar>
                            </ListItemAvatar>
                            <ListItemText primary={number} secondary={imei}/>
                        </ListItem>}
                    </React.Fragment>;
                }) : <ListItem divider>
                    <ListItemAvatar>
                        <Avatar>
                            <SearchIcon/>
                        </Avatar>
                    </ListItemAvatar>
                    <ListItemText primary={prefix} secondary={'Ничего не найдено 🤷'}/>
                </ListItem>
        }

    </div>;
}