import { Avatar, createStyles, ListItem, ListItemAvatar, ListItemText, makeStyles, Theme } from '@material-ui/core';
import React from 'react';

const useStyles = makeStyles((theme: Theme) =>
    createStyles({
        large: {
            width: theme.spacing(6),
            height: theme.spacing(6),
        }
    }),
);

export default function UserInfo() {
    const classes = useStyles();
    let user_name = getCookie('yandex_login');
    return <ListItem divider>
        <ListItemAvatar>
            <Avatar alt="avatar"
                    src={`https://center.yandex-team.ru/api/v1/user/${user_name}/avatar/100.jpg`}
                    className={classes.large}>{user_name?.substr(0, 2)?.toUpperCase()}</Avatar>
        </ListItemAvatar>
        <ListItemText primary={user_name} secondary={process.env.VERSION}/>
    </ListItem>;
}

function getCookie(name) {
    let matches = document.cookie.match(new RegExp(
        '(?:^|; )' + name.replace(/([\.$?*|{}\(\)\[\]\\\/\+^])/g, '\\$1') + '=([^;]*)'
    ));
    return matches ? decodeURIComponent(matches[1]) : undefined;
}