export const ONE_SECOND = 1000;

export const DIGIT_THOUSAND = 1000;
export const ONE_MINUTE = ONE_SECOND * 60;
export const ONE_HOUR = ONE_MINUTE * 60;
export const ONE_DAY = ONE_HOUR * 24;

export const prettySeconds = (lag: number): string => {
    let rezult = '';
    if (lag < ONE_MINUTE / ONE_SECOND) {
        rezult = lag.toFixed(1) + ' cек.';
    }

    if (lag >= ONE_MINUTE / ONE_SECOND && lag < ONE_HOUR / ONE_SECOND) {
        rezult = (lag / (ONE_MINUTE / ONE_SECOND)).toFixed(1) + ' мин.';
    }

    if (lag >= ONE_HOUR / ONE_SECOND && lag < ONE_DAY / ONE_SECOND) {
        rezult = (lag / (ONE_HOUR / ONE_SECOND)).toFixed(1) + ' час.';
    }

    if (lag >= ONE_DAY / ONE_SECOND) {
        rezult = (lag / (ONE_DAY / ONE_SECOND)).toFixed(1) + ' дн.';
    }

    return rezult;
};

export const dateLag = (date: any) => {
    let lag: any = (new Date().getTime() - date * ONE_SECOND) / ONE_SECOND;
    return prettySeconds(lag);
};