import React from 'react';
import Search from '../components/Search';


export const EMPTY_DATA = '—';

const Cars = React.lazy(() => import('../components/Cars'));
const Home = React.lazy(() => import('../components/Home'));

interface IRoutConfig {
    path: string
    menuTitle?: string
    component: any
    menuIndex?: number
    ignoreMenu?: boolean
    description?: string
}

interface IRoutItem {
    [key: string]: IRoutConfig
}

const ROUTS: IRoutItem = {
    search: {
        path: '/search/:prefix',
        component: Search,
        ignoreMenu: true
    },
    cars: {
        path: '/cars/:car_number/:prefix?',
        component: Cars,
        ignoreMenu: true
    },
    home: {
        path: '/',
        menuTitle: 'Домой',
        component: Home,
        menuIndex: 0
    },
};
export default ROUTS;
