import { Dispatch, SetStateAction, useEffect, useState } from 'react';

interface IFetchOptions {
    url: string,
    options?: {
        [key: string]: any,
        method?: string,
        body?: string,
    }
}

const useData = <T extends any>(isLoadingInit?: boolean): [{ isLoading: boolean, data: T | null, error: any }, Dispatch<SetStateAction<IFetchOptions>>] => {
    let [isLoading, setLoading] = useState(true);
    let [data, setData] = useState<T>();
    let [error, setError] = useState<any | null>(null);
    let [fetchOptions, setFetchOptions] = useState<IFetchOptions | null>(null);

    const fetchData = async (fetchOptions) => {
        setLoading(true);
        setError(null);
        let {url, options} = fetchOptions;

        if(process.env.BACKEND_CLUSTER) {
            url = `${url}${url.includes('?') ? '&' : '?'}backend_cluster=${process.env.BACKEND_CLUSTER}`;
        }
        let response = await fetch(url, options);

        if (response.ok) {
            let data = await response.json();
            setData(data);
            setLoading(false);
        } else {
            let errorText = await response.text();

            try {
                error = JSON.parse(errorText);
            } catch {
                let status = response.status;
                error = {
                    message: errorText,
                    status
                };
            }

            setError(error);
            setLoading(false);
        }
    };

    useEffect(() => {
        setLoading(isLoadingInit ?? false)
    }, [isLoadingInit])

    useEffect(() => {
        fetchOptions && fetchData(fetchOptions);
    }, [fetchOptions]);

    return [{isLoading, data: data ?? null, error}, setFetchOptions];
};

export default useData;
