const merge = require('webpack-merge');

const common = require('./configs/webpack/webpack.common');
const development = require('./configs/webpack/webpack.development');
const production = require('./configs/webpack/webpack.production');
const bundle_analyzer = require('./configs/webpack/webpack.bundle_analyzer');

module.exports = ({mode, type} = {mode: 'production'}) => {
    const defaultConfig = merge.smart({mode}, common);
    const productionConfig = merge.smart(defaultConfig, production);

    if (type === 'analyze') {
        return module.exports = merge(productionConfig, bundle_analyzer);
    }

    if (mode === 'production') {
        return module.exports = productionConfig;
    }

    if (mode === 'development') {
        return module.exports = merge.smart(defaultConfig, development);
    }
};
