const LOCALHOST_URL = 'https://localhost.yandex-team.ru:9000/';
const PRODUCTION_URL = 'https://carsharing.yandex-team.ru/';

chrome.browserAction.onClicked.addListener(function () {
    chrome.tabs.query({currentWindow: true, active: true}, function (tab) {
        let oldUrl = tab[0] && tab[0].url;
        let newUrl = tab[0] && tab[0].url;

        if (newUrl.indexOf(LOCALHOST_URL) === 0) {
            newUrl = newUrl.replace(LOCALHOST_URL,
                PRODUCTION_URL);
        } else if (newUrl.indexOf(PRODUCTION_URL) === 0) {
            newUrl = newUrl.replace(PRODUCTION_URL,
                LOCALHOST_URL)
        }
        if (oldUrl !== newUrl) {
            chrome.tabs.update(tab.id, {url: newUrl});
        }
    });
});