import express from 'express';
import { leasingRouter } from './routers/leasingRouter';
import { chatRouter } from './routers/chatRouter';
import bodyParser from 'body-parser';

const app = express();
const PORT = 7000;

app.use(bodyParser.json({type: 'application/json'}));

app.get('/', (req, res) => {
    res.status(400).json({message: 'You should config own api/router'});
});

app.use('/leasing-api', leasingRouter);

app.use('/chat-api-test', chatRouter);

app.listen(PORT, () => {
    console.log(`⚡️[server]: Mock server is running at http://localhost:${PORT}`);
});