import { IValueType } from './types';

interface IPortfolioValue {
    name: string,
    display_name: string,
    type: IValueType,
    all_cars?: { current: any, shift: any, shift_type: IValueType },
    telematics_cars?: { current: any, shift: any, shift_type: IValueType }
}

export interface IPortfolioResponse {
    common_score: number,
    values: IPortfolioValue[]
}

export const PORTFOLIO_SUCCESS: IPortfolioResponse = {
    common_score: 4.2,
    values: [
        {
            name: 'lease', display_name: 'Сдаваемость', type: IValueType.PERCENT,
            all_cars: {current: 87, shift: 5, shift_type: IValueType.PERCENT},
            telematics_cars: {current: 87, shift: 5, shift_type: IValueType.PERCENT}
        },
        {
            name: 'cars', display_name: 'Машины', type: IValueType.NUMERIC,
            all_cars: {current: 15651, shift: 5, shift_type: IValueType.PERCENT},
            telematics_cars: {current: 15651, shift: 5, shift_type: IValueType.PERCENT}
        },
        {
            name: 'comission_per_car',
            display_name: 'Комиссия на 1 машину',
            type: IValueType.NUMERIC,
            all_cars: {current: 1325600, shift: 5, shift_type: IValueType.PERCENT},
            telematics_cars: {current: 1325600, shift: 5, shift_type: IValueType.PERCENT}
        },
        {
            name: 'no_sh', display_name: 'Не выполняют SH', type: IValueType.NUMERIC,
            telematics_cars: {current: 67, shift: -2, shift_type: IValueType.NUMERIC}
        },
        {
            name: 'mileage_per_car', display_name: 'Пробег на 1 машину', type: IValueType.NUMERIC,
            telematics_cars: {current: 15651, shift: 5, shift_type: IValueType.PERCENT}
        },
        {
            name: 'driving_quality', display_name: 'Качество вождения', type: IValueType.NUMERIC,
            telematics_cars: {current: 4.5, shift: -0.1, shift_type: IValueType.NUMERIC}
        },
        {
            name: 'no_mileage', display_name: 'Машины без пробега', type: IValueType.NUMERIC,
            all_cars: {current: 65, shift: 2, shift_type: IValueType.NUMERIC},
            telematics_cars: {current: 67, shift: -2, shift_type: IValueType.NUMERIC}
        },
        {
            name: 'SLA_excess', display_name: 'Машины, превысившие SLA устранения ошибок', type: IValueType.NUMERIC,
            telematics_cars: {current: 67, shift: -2, shift_type: IValueType.NUMERIC}
        },
    ]
};

export const PORTFOLIO_WITHOUT_SCORE: any = {
    values: [
        {
            name: 'lease', display_name: 'Сдаваемость', type: IValueType.PERCENT,
            all_cars: {current: 87, shift: 5, shift_type: IValueType.PERCENT},
            telematics_cars: {current: 87, shift: 5, shift_type: IValueType.PERCENT}
        },
        {
            name: 'cars', display_name: 'Машины', type: IValueType.NUMERIC,
            all_cars: {current: 15651, shift: 5, shift_type: IValueType.PERCENT},
            telematics_cars: {current: 15651, shift: 5, shift_type: IValueType.PERCENT}
        },
        {
            name: 'comission_per_car',
            display_name: 'Комиссия на 1 машину',
            type: IValueType.NUMERIC,
            all_cars: {current: 1325600, shift: 5, shift_type: IValueType.PERCENT},
            telematics_cars: {current: 1325600, shift: 5, shift_type: IValueType.PERCENT}
        },
        {
            name: 'no_sh', display_name: 'Не выполняют SH', type: IValueType.NUMERIC,
            telematics_cars: {current: 67, shift: -2, shift_type: IValueType.NUMERIC}
        },
        {
            name: 'mileage_per_car', display_name: 'Пробег на 1 машину', type: IValueType.NUMERIC,
            telematics_cars: {current: 15651, shift: 5, shift_type: IValueType.PERCENT}
        },
        {
            name: 'driving_quality', display_name: 'Качество вождения', type: IValueType.NUMERIC,
            telematics_cars: {current: 4.5, shift: -0.1, shift_type: IValueType.NUMERIC}
        },
        {
            name: 'no_mileage', display_name: 'Машины без пробега', type: IValueType.NUMERIC,
            all_cars: {current: 65, shift: 2, shift_type: IValueType.NUMERIC},
            telematics_cars: {current: 67, shift: -2, shift_type: IValueType.NUMERIC}
        },
        {
            name: 'SLA_excess', display_name: 'Машины, превысившие SLA устранения ошибок', type: IValueType.NUMERIC,
            telematics_cars: {current: 67, shift: -2, shift_type: IValueType.NUMERIC}
        },
    ]
};

export const PORTFOLIO_WITHOUT_VALUES: any = {
    common_score: 4.2
};

export const PORTFOLIO_WITHOUT_VALUE: IPortfolioResponse = {
    common_score: 4.2,
    values: [
        {
            name: 'lease', display_name: 'Сдаваемость', type: IValueType.PERCENT,
            all_cars: {current: 87, shift: 5, shift_type: IValueType.PERCENT},
            telematics_cars: {current: 87, shift: 5, shift_type: IValueType.PERCENT}
        },
        {
            name: 'cars', display_name: 'Машины', type: IValueType.NUMERIC,
            all_cars: {current: 15651, shift: 5, shift_type: IValueType.PERCENT},
            telematics_cars: {current: 15651, shift: 5, shift_type: IValueType.PERCENT}
        }
    ]
};