import { IValueType } from './types';

export interface ICarsResponse {
    cars: any[],
    page: number,
    can_get_more: boolean
}

export const TAXI_PARK_CARS_SUCCESS: ICarsResponse = {
    cars: [
        {
            car_id: '1',
            model: 'Renault Kaptur',
            number: 'С065МК',
            mileage_per_week: {value: 71, value_type: IValueType.KILOMETERS},
            idle_time: {value: 12, value_type: IValueType.HOURS},
            taxi_park: 'ТаксиЛэнд'
        },
        {
            car_id: '2',
            model: 'Renault Kaptur',
            number: 'С066МК',
            mileage_per_week: {value: 571, value_type: IValueType.KILOMETERS},
            idle_time: {value: 10, value_type: IValueType.HOURS},
            taxi_park: 'Золотой Гусь'
        },
        {
            car_id: '3',
            model: 'Renault Kaptur',
            number: 'С067МК',
            mileage_per_week: {value: 71, value_type: IValueType.KILOMETERS},
            idle_time: {value: 4, value_type: IValueType.HOURS},
            taxi_park: 'Партнер_ИП_С1234567890'
        }
    ],
    page: 1,
    can_get_more: true
};