import express, { Response } from 'express';
import { createChatResponse, DISPATCHER_RESPONSE } from '../mock-responses/chat-responses/chat-responses';

const chatRouter = express.Router();

chatRouter.get('/chats/feed', (req: any, res: Response<any>) => {
    if (!req.query.performer_id) {
        //ALL
        res.json(createChatResponse());
    } else if (req.query.performer_id == 0) {
        //NEW
        res.json(createChatResponse());
    } else {
        //MY
        res.json(DISPATCHER_RESPONSE);
    }
});

export { chatRouter };
