import express, { Response } from "express";
import delay from "express-delay";
import { IPortfolioResponse, PORTFOLIO_SUCCESS } from "../mock-responses/portfolio";
import { ITaxiParksResponse, TAXI_PARKS_SUCCESS } from "../mock-responses/taxiparks";
import { CARS_SUCCESS, ICarsResponse } from "../mock-responses/cars";
import { TAXI_PARK_CARS_SUCCESS } from "../mock-responses/taxipark_cars";
import dm_images from "../mock-responses/dm-images";

const leasingRouter = express.Router();
const delayMin = 200;
const delayMax = 1000;

interface errorResp {

}

leasingRouter.use(delay(delayMin, delayMax));

leasingRouter.post("/portfolio", (req: any, res: Response<IPortfolioResponse | errorResp>) => {
  res.json(PORTFOLIO_SUCCESS);
  //res.status(409).json({someMessage: 'any error text'});
});

leasingRouter.get("/taxiparks", (req: any, res: Response<ITaxiParksResponse | errorResp>) => {
  res.json(TAXI_PARKS_SUCCESS);
  //res.status(409).json({someMessage: 'any error text'});
});

leasingRouter.get("/cars", (req: any, res: Response<ICarsResponse | errorResp>) => {
  res.json(CARS_SUCCESS);
});

leasingRouter.get("/park", (req: any, res: Response<ICarsResponse | errorResp>) => {
  res.json(TAXI_PARK_CARS_SUCCESS);
});

leasingRouter.get("/photo/markup/get", (req: any, res: Response<ICarsResponse | errorResp>) => {
  res.json(dm_images);
});

export { leasingRouter };