const path = require('path');
const crypto = require('crypto');

const packageLocks = ['./package-lock.json']
    .map((lockFile) => require(path.join(process.cwd(), lockFile)))
    .map(({ dependencies }) => dependencies);

const dependenciesSha1 = crypto
    .createHash('sha1')
    .update(JSON.stringify({ packageLocks }))
    .digest('hex');

console.log(dependenciesSha1);
