#!/usr/bin/env node
const yargs = require('yargs/yargs');
const {execSync} = require('child_process');
const fs = require('fs');

const buildDocker = require('./lib/buildDocker');
const buildRelease = require('./lib/buildRelease');
const DeployTarget = require('./utils/enum/deployTarget');
const prepareQtoolsConfig = require('./utils/prepareQtoolsConfig');
const prepareProjectConfig = require('./utils/prepareProjectConfig');
const prepareUpstreamConfig = require('./utils/prepareUpstreamConfig');
const updateBalancer = require('./utils/updateBalancer');

const argv = yargs(process.argv.slice(2))
    .usage('Usage: $0 <command> [options]')
    .command('stand', 'Prepare config for stand')
    .alias('ticket', 't')
    .nargs('ticket', 1)
    .describe('ticket', 'Startrek ticket')
    .alias('docker_image_name', 'i')
    .nargs('i', 1)
    .describe('i', 'Docker image name')
    .demandOption(['ticket', 'docker_image_name'])
    .help('h')
    .alias('h', 'help')
    .argv;

if (argv._[0] === 'stand') {
    execSync(
        `git-restore-mtime`,
        {
            stdio: 'inherit',
            shell: process.env.SHELL
        },
    );

    // change revision to variable later
    let appVersion = execSync('npm --no-git-tag-version version prerelease -f --loglevel=error', {
        stdio: 'pipe',
        shell: process.env.SHELL
    });

    if (appVersion.toString) {
        appVersion = appVersion.toString().replace(/\n/g, '');
    }

    let ticketFormatted = argv.ticket.toLowerCase();
    let dockerTag = `${ticketFormatted}_${appVersion}`;

    if (!fs.existsSync(`${process.cwd()}/.configs/deploy/`)){
        fs.mkdirSync(`${process.cwd()}/.configs/deploy/`, {recursive: true})
    }

    prepareUpstreamConfig(ticketFormatted);
    prepareQtoolsConfig(dockerTag, DeployTarget.STAND);
    prepareProjectConfig(ticketFormatted, argv.docker_image_name, dockerTag);

    buildRelease();
    buildDocker(dockerTag, DeployTarget.STAND, undefined);
    updateBalancer(ticketFormatted).then(() => {
        // move stand name to config
        console.log(`Domain: https://${ticketFormatted}.stand.carsharing.yandex-team.ru`);
        console.log('Remove temporary configs...');

        fs.unlink(`${process.cwd()}/.qtools.json`, () => {});
        fs.rmdir(`${process.cwd()}/.configs`, { recursive: true }, () => {});
    })
}
