const {getRelease} = require('../utils/getRelease');
const ReleaseType = require('../utils/enum/releaseType');
const {execSync} = require('child_process');
const RELEASE_FOLDER = 'releases';

/**
 *  @param {DeployTarget} deployTarget
 *  @param {string | undefined} previousReleaseVersion
 */
const getReleaseDirForStand = (deployTarget, previousReleaseVersion) => {
    let latestRelease = getRelease(ReleaseType.LATEST, deployTarget);
    let previousRelease;

    if (previousReleaseVersion) {
        previousRelease = `${RELEASE_FOLDER}/${previousReleaseVersion}`;
    } else {
        previousRelease = getRelease(ReleaseType.PREVIOUS, deployTarget)
    }

    return {latestRelease, previousRelease};
}

/**
 *  @param {string} dockerTag
 *  @param {DeployTarget} deployTarget
 *  @param {string | undefined} previousReleaseVersion
 */
module.exports = (dockerTag, deployTarget, previousReleaseVersion) => {
    console.info('Building Docker image...');

    let {latestRelease, previousRelease} = getReleaseDirForStand(deployTarget, previousReleaseVersion);
    console.info(`Latest release: ${latestRelease}\n Previous release: ${previousRelease}`);

    execSync(
        `${__dirname.split('/').slice(0, -1).join('/')}/node_modules/.bin/qtools release stand --force -- --build-arg LATEST_RELEASE="${latestRelease}" --build-arg PREVIOUS_RELEASE="${previousRelease}"`,
        {
            stdio: 'inherit',
            shell: process.env.SHELL
        },
    )
}
