const yaml = require('js-yaml');
const fs = require('fs');
const path = require('path');

module.exports = (stageName, dockerImageName, dockerTag) => {
    let configToPrepare = yaml.load(fs.readFileSync(path.resolve(__dirname , '../defaults/default.stand.yaml')));

    configToPrepare.spec.deploy_units.front.images_for_boxes.front_box.name = dockerImageName;
    configToPrepare.spec.deploy_units.front.images_for_boxes.front_box.tag = dockerTag;
    configToPrepare.meta.id = stageName;

    try {
        fs.writeFileSync(`${process.cwd()}/.configs/deploy/stand.yml`, yaml.dump(configToPrepare));
        console.log("Stage config was created successfully!");

        fs.writeFileSync(
            `${process.cwd()}/.configs/deploy/project.yml`,
            fs.readFileSync(path.resolve(__dirname , '../defaults/default.project.yaml'))
        );
        console.log("Project config was created successfully!");
    } catch (e) {
        throw new Error(`Creating config failed: ${e}`);
    }
}
