const fs = require('fs');

const getDockerfile = require('../utils/getDockerfile');
const qtoolsConfig = require('../defaults/default.qtools.json');

module.exports = (dockerTag, deployTarget) => {
    try {
        let configToPrepare = qtoolsConfig;
        let dockerfile = getDockerfile(deployTarget);

        configToPrepare.registry.tag = dockerTag;
        configToPrepare.registry.dockerfile = dockerfile;

        let configToWrite = JSON.stringify(configToPrepare, null, 4);

        fs.writeFileSync(
            `${process.cwd()}/.qtools.json`,
            configToWrite
        );
        console.log("Qtools config was created successfully!");
    } catch (e) {
        throw new Error(`Creating qtools config failed: ${e}`);
    }
}
