const yaml = require('js-yaml');
const fs = require('fs');
const path = require('path');

module.exports = (ticket) => {
    try {
        let configToPrepare = yaml.load(fs.readFileSync(path.resolve(__dirname , '../defaults/default.upstream.yaml')));
        configToPrepare.l7_upstream_macro.id = ticket;
        configToPrepare.l7_upstream_macro.matcher.host_re = `${ticket}.stand.carsharing.yandex-team.ru`
        configToPrepare.l7_upstream_macro.flat_scheme.backend_ids = [ticket];

        fs.writeFileSync(`${process.cwd()}/.configs/deploy/upstream.yml`, yaml.dump(configToPrepare));
        console.log("Upstream config was created successfully!");
    } catch (e) {
        throw new Error(`Creating upstream config failed: ${e}`);
    }
}
