import { translate } from '../../../utils/translate';
import { Form, Select } from 'antd';
import React, { useCallback, useState } from 'react';
import PropTypes from 'prop-types';
import { debounce } from '../../../utils/helpers';
import './AddressSearch.less';

const DEBOUNCE_MS = 300;

export const AddressSearch = ({ onAddressSearch }) => {
    const [addressSuggestOptions, setAddressSuggestOptions] = useState([]);
    const [isAddressLoading, setIsAddressLoading] = useState(false);
    const [selectedAddress, setSelectedAddress] = useState('');

    const handleAddressSearch = useCallback(
        debounce(async (query) => {
            setIsAddressLoading(true);
            setAddressSuggestOptions([]);

            try {
                const results = await onAddressSearch(query);

                setAddressSuggestOptions(results);
            } catch (err) {
                console.warn(err);
                setAddressSuggestOptions([]);
            } finally {
                setIsAddressLoading(false);
            }
        }, DEBOUNCE_MS),
        [],
    );

    return <Form.Item label={translate('field_search_suggest')}>
        <Select
            autoFocus={true}
            allowClear
            showSearch
            placeholder={translate('field_search_suggest_placeholder')}
            defaultActiveFirstOption={false}
            filterOption={false}
            onChange={setSelectedAddress.bind(null, '')}
            onSearch={handleAddressSearch}
            onSelect={setSelectedAddress.bind(null)}
            options={addressSuggestOptions.map(({ address, components }) => ({ value: address, components }))}
            loading={isAddressLoading}
        />

        <div className="select__label">{selectedAddress}</div>
    </Form.Item>;
};

AddressSearch.propTypes = {
    onAddressSearch: PropTypes.func.isRequired,
};
