import React from 'react';
import PropTypes from 'prop-types';
import { Form, Checkbox, Select } from 'antd';
import { CalendarOutlined } from '@ant-design/icons';
import { translate } from '../../../utils/translate';
import { LICENSE_CATEGORIES } from '../../../domain/documents';
import { TextField } from '../TextField';
import { Hint } from '../../Utility/Hint';

export const LicenseBack = ({ availableFields, disabled = true }) => {
    const renderField = (fieldName, index) => {
        const tabIndex = index + 1;

        switch (fieldName) {
            case 'number':
                return (
                    <TextField
                        key={fieldName}
                        tabIndex={tabIndex}
                        name="number"
                        placeholder={translate('field_license_number_placeholder')}
                        disabled={disabled}
                    />
                );

            case 'categories':
                return (
                    <Form.Item key={fieldName} label={translate('field_categories')} name="categories">
                        <Select
                            placeholder={translate('field_categories_placeholder')}
                            tabIndex={tabIndex}
                            allowClear
                            disabled={disabled}
                        >
                            {Object.values(LICENSE_CATEGORIES).map((category) => (
                                <Select.Option key={category} value={category}>
                                    {translate(`license_category_${category}`)}
                                </Select.Option>
                            ))}
                        </Select>
                    </Form.Item>
                );

            case 'categories_b_valid_from_date':
                return (
                    <TextField
                        key={fieldName}
                        tabIndex={tabIndex}
                        name="categories_b_valid_from_date"
                        placeholder={translate('field_date_placeholder')}
                        addonBefore={<CalendarOutlined />}
                        mask="1111-11-11"
                        disabled={disabled}
                    />
                );

            case 'categories_b_valid_to_date':
                return (
                    <TextField
                        key={fieldName}
                        tabIndex={tabIndex}
                        name="categories_b_valid_to_date"
                        placeholder={translate('field_date_placeholder')}
                        addonBefore={<CalendarOutlined />}
                        mask="1111-11-11"
                        disabled={disabled}
                    />
                );

            case 'special_category_b_date':
                return (
                    <TextField
                        key={fieldName}
                        tabIndex={tabIndex}
                        name="special_category_b_date"
                        placeholder={translate('field_date_placeholder')}
                        addonBefore={<CalendarOutlined />}
                        mask="1111-11-11"
                        disabled={disabled}
                    />
                );

            case 'prev_licence_issue_date':
                return (
                    <TextField
                        key={fieldName}
                        tabIndex={tabIndex}
                        name="prev_licence_issue_date"
                        placeholder={translate('field_date_placeholder')}
                        addonBefore={<CalendarOutlined />}
                        mask="1111-11-11"
                        disabled={disabled}
                    />
                );

            case 'prev_licence_number':
                return (
                    <TextField
                        key={fieldName}
                        tabIndex={tabIndex}
                        name="prev_licence_number"
                        placeholder={translate('field_license_number_placeholder')}
                        disabled={disabled}
                    />
                );

            case 'experience_from':
                return (
                    <TextField
                        key={fieldName}
                        tabIndex={tabIndex}
                        name="experience_from"
                        placeholder={translate('field_date_placeholder')}
                        addonBefore={<CalendarOutlined />}
                        mask="1111-11-11"
                        disabled={disabled}
                    />
                );

            case 'has_at_mark':
                return (
                    <Hint title={translate('field_has_at_mark_hint')} placement="topLeft" key={fieldName}>
                        <Form.Item label={translate('field_has_at_mark')} name="has_at_mark" valuePropName="checked">
                            <Checkbox tabIndex={tabIndex} disabled={disabled} />
                        </Form.Item>
                    </Hint>
                );
        }
    };

    return availableFields.map(renderField);
};

LicenseBack.propTypes = {
    availableFields: PropTypes.arrayOf(PropTypes.string.isRequired).isRequired,
    disabled: PropTypes.bool,
};
