import React, { useRef } from 'react';
import PropTypes from 'prop-types';
import { Form, Select } from 'antd';
import { CalendarOutlined } from '@ant-design/icons';
import { translate } from '../../../utils/translate';
import { LICENSE_CATEGORIES } from '../../../domain/documents';
import { TextField } from '../TextField';

export const LicenseFront = ({ availableFields, disabled = true }) => {
    const categoriesRef = useRef(null);

    const renderField = (fieldName, index) => {
        const tabIndex = index + 1;
        const optionalHint = ['middle_name'].includes(fieldName) ? translate('field_optional_value_hint') : null;

        switch (fieldName) {
            case 'last_name':
            case 'first_name':
            case 'middle_name':
                return (
                    <TextField
                        key={fieldName}
                        tabIndex={tabIndex}
                        name={fieldName}
                        placeholder={translate(`field_${fieldName}_placeholder`)}
                        hint={optionalHint}
                        disabled={disabled}
                    />
                );

            case 'birth_date':
                return (
                    <TextField
                        key={fieldName}
                        tabIndex={tabIndex}
                        name="birth_date"
                        placeholder={translate('field_date_placeholder')}
                        addonBefore={<CalendarOutlined />}
                        mask="1111-11-11"
                        disabled={disabled}
                    />
                );

            case 'number':
                return (
                    <TextField
                        key={fieldName}
                        tabIndex={tabIndex}
                        name="number"
                        placeholder={translate('field_license_number_placeholder')}
                        disabled={disabled}
                    />
                );

            case 'prev_licence_number':
                return (
                    <TextField
                        key={fieldName}
                        tabIndex={tabIndex}
                        name="prev_licence_number"
                        placeholder={translate('field_license_number_placeholder')}
                        disabled={disabled}
                    />
                );

            case 'categories':
                return (
                    <Form.Item
                        key={fieldName}
                        label={translate('field_categories')}
                        name="categories"
                    >
                        <Select
                            placeholder={translate('field_categories_placeholder')}
                            tabIndex={tabIndex}
                            allowClear
                            showSearch
                            optionFilterProp="children"
                            showAction={['click', 'focus']}
                            onFocus={() => categoriesRef.current.focus()}
                            ref={categoriesRef}
                            disabled={disabled}
                        >
                            {Object.values(LICENSE_CATEGORIES).map((category) => (
                                <Select.Option key={category} value={category}>
                                    {translate(`license_category_${category}`)}
                                </Select.Option>
                            ))}
                        </Select>
                    </Form.Item>
                );

            case 'categories_b_valid_to_date':
                return (
                    <TextField
                        key={fieldName}
                        tabIndex={tabIndex}
                        name="categories_b_valid_to_date"
                        placeholder={translate('field_date_placeholder')}
                        addonBefore={<CalendarOutlined />}
                        mask="1111-11-11"
                        disabled={disabled}
                    />
                );

            case 'special_category_b_date':
                return (
                    <TextField
                        key={fieldName}
                        tabIndex={tabIndex}
                        name="special_category_b_date"
                        placeholder={translate('field_date_placeholder')}
                        addonBefore={<CalendarOutlined />}
                        mask="1111-11-11"
                        disabled={disabled}
                    />
                );

            case 'experience_from':
                return (
                    <TextField
                        key={fieldName}
                        tabIndex={tabIndex}
                        name="experience_from"
                        placeholder={translate('field_date_placeholder')}
                        addonBefore={<CalendarOutlined />}
                        mask="1111-11-11"
                        disabled={disabled}
                    />
                );

            case 'issue_date':
                return (
                    <TextField
                        key={fieldName}
                        tabIndex={tabIndex}
                        name="issue_date"
                        placeholder={translate('field_date_placeholder')}
                        addonBefore={<CalendarOutlined />}
                        mask="1111-11-11"
                        disabled={disabled}
                    />
                );

            case 'prev_licence_issue_date':
                return (
                    <TextField
                        key={fieldName}
                        tabIndex={tabIndex}
                        name="prev_licence_issue_date"
                        placeholder={translate('field_date_placeholder')}
                        addonBefore={<CalendarOutlined />}
                        required={false}
                        mask="1111-11-11"
                        disabled={disabled}
                    />
                );
        }
    };

    return availableFields.map(renderField);
};

LicenseFront.propTypes = {
    availableFields: PropTypes.arrayOf(PropTypes.string.isRequired).isRequired,
    disabled: PropTypes.bool,
};
