import React from 'react';
import PropTypes from 'prop-types';
import { CalendarOutlined } from '@ant-design/icons';
import { translate } from '../../../utils/translate';
import { TextField } from '../TextField';
import { AddressSearch } from '../AddressSearch/AddressSearch';

export const PassportReg = ({ availableFields, disabled = true, onAddressSearch }) => {
    const renderField = (fieldName, index) => {
        const tabIndex = index + 1;

        switch (fieldName) {
            case 'region':
                return (
                    <TextField
                        key={fieldName}
                        tabIndex={tabIndex}
                        name="region"
                        placeholder={translate('field_region_placeholder')}
                        disabled={disabled}
                    />
                );

            case 'area':
                return (
                    <TextField
                        key={fieldName}
                        tabIndex={tabIndex}
                        name="area"
                        placeholder={translate('field_area_placeholder')}
                        disabled={disabled}
                    />
                );

            case 'locality':
                return (
                    <TextField
                        key={fieldName}
                        tabIndex={tabIndex}
                        name="locality"
                        placeholder={translate('field_locality_placeholder')}
                        disabled={disabled}
                    />
                );

            case 'street':
                return (
                    <TextField
                        key={fieldName}
                        tabIndex={tabIndex}
                        name="street"
                        placeholder={translate('field_street_placeholder')}
                        disabled={disabled}
                    />
                );

            case 'house':
                return (
                    <TextField
                        key={fieldName}
                        tabIndex={tabIndex}
                        name="house"
                        placeholder={translate('field_house_placeholder')}
                        disabled={disabled}
                    />
                );

            case 'housing':
                return (
                    <TextField
                        key={fieldName}
                        tabIndex={tabIndex}
                        name="housing"
                        placeholder={translate('field_housing_placeholder')}
                        disabled={disabled}
                    />
                );

            case 'registration_letter':
                return (
                    <TextField
                        key={fieldName}
                        tabIndex={tabIndex}
                        name="registration_letter"
                        placeholder={translate('field_registration_letter_placeholder')}
                        disabled={disabled}
                    />
                );

            case 'apartment':
                return (
                    <TextField
                        key={fieldName}
                        tabIndex={tabIndex}
                        name="apartment"
                        placeholder={translate('field_apartment_placeholder')}
                        disabled={disabled}
                    />
                );

            case 'registration_expiration_date':
                return (
                    <TextField
                        key={fieldName}
                        tabIndex={tabIndex}
                        name="registration_expiration_date"
                        placeholder={translate('field_date_placeholder')}
                        addonBefore={<CalendarOutlined />}
                        mask="1111-11-11"
                        disabled={disabled}
                    />
                );
        }
    };

    return <>
        <AddressSearch onAddressSearch={onAddressSearch} />

        {availableFields.map(renderField)}
    </>;
};

PassportReg.propTypes = {
    availableFields: PropTypes.arrayOf(PropTypes.string.isRequired).isRequired,
    disabled: PropTypes.bool,
    onAddressSearch: PropTypes.func,
};
