import { connect } from 'react-redux';
import { setVerdictAndComment, setAdditionalFields } from '../../domain/store/actions/solution';
import { setTaskError } from '../../domain/store/actions/ui';
import { DocumentView } from './Document';
import {fetchAddressUsecase} from '../../usecases/fetchAddressUsecase';

const mapStateToProps = (state, { documentType }) => {
    const { scaleOptions, taskError, activeDocumentIndex } = state.ui;
    const { documents } = state.documents;
    const { facts, meta } = state.input;
    const { solution } = state;

    return {
        fieldsData: documents[documentType]?.data,
        verdicts: solution.verdicts[documentType],
        comment: solution.comments[documentType],
        facts: facts[documentType],
        scaleOptions,
        taskError,
        activeDocumentIndex,
        feedback: meta.comment,
    };
};

const mapDispatchToProps = (dispatch, { documentType }) => ({
    onVerdictChange: (values) => dispatch(setVerdictAndComment(values)),
    onAdditionalFieldsChange: ({ name, value }) => dispatch(setAdditionalFields({ documentType, name, value })),
    resetTaskError: () => dispatch(setTaskError(null)),
    onAddressSearch: fetchAddressUsecase,
});

export const Document = connect(mapStateToProps, mapDispatchToProps)(DocumentView);
