import React, { useRef } from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import ImageViewer from 'react-wp-viewer';

export const PhotoViewer = ({ src, alt }) => {
    const imageRef = useRef(null);

    return (
        <div className={classNames('photo-viewer', document)} ref={imageRef}>
            <ImageViewer
                container={imageRef}
                visible={true}
                changeable={false}
                noClose={true}
                noNavbar={true}
                noResetAfterChange={true}
                noImgDetails={true}
                showTotal={false}
                disableKeyboardSupport={true}
                zoomSpeed={0.35}
                images={[{ src, alt }]}
            />
        </div>
    );
};

PhotoViewer.propTypes = {
    src: PropTypes.string.isRequired,
    alt: PropTypes.string,
};
