import { connect } from 'react-redux';
import { TaskPageLayoutView } from './TaskPageLayout';
import { getDocumentsUsecase } from '../../usecases/getDocumentsUsecase';

const mapStateToProps = (state) => {
    const { secret, documentTypes, presets } = state.input;

    return {
        secret,
        documentTypes,
        presets,
    };
};

const mapDispatchToProps = () => ({
    loadDocuments: getDocumentsUsecase,
});

export const TaskPageLayout = connect(mapStateToProps, mapDispatchToProps)(TaskPageLayoutView);
