import React from 'react';
import PropTypes from 'prop-types';
import ReactPlayer from 'react-player';
import './VideoPlayer.less';

export const VideoPlayer = ({ src, onEnded = () => {} }) => (
    <div className="video-player__wrapper">
        <ReactPlayer
            className="video-player"
            url={src}
            controls
            playing
            muted
            width="100%"
            height="100%"
            volume={0}
            pip={false}
            config={{ file: { attributes: { disablePictureInPicture: true, controlsList: 'nodownload' } } }}
            onEnded={onEnded}
            onError={onEnded}
        />
    </div>
);

VideoPlayer.propTypes = {
    src: PropTypes.string.isRequired,
    onEnded: PropTypes.func,
};
