import { connect } from 'react-redux';
import { DOCUMENT_TYPES } from '../../domain/documents';
import { getMediaLinksUsecase } from '../../usecases/getMediaLinksUsecase';
import { ViewerPaneView } from './ViewerPane';

const mapStateToProps = (state, { documentTypes }) => {
    const { activeDocumentIndex, scaleOptions } = state.ui;
    const { secret, presets } = state.input;

    const activeDocumentType = documentTypes[activeDocumentIndex];
    const isPreset = !Object.values(DOCUMENT_TYPES).includes(activeDocumentType);

    const documents = isPreset ? presets[activeDocumentType].document_types : [activeDocumentType];
    const isVideoAvailable = isPreset ? presets[activeDocumentType].is_video_available : true;

    return {
        documents,
        isVideoAvailable,
        isVideoPreferred: scaleOptions.preferVideo,
        secret,
    };
};

const mapDispatchToProps = () => ({
    getMediaLink: getMediaLinksUsecase,
});

export const ViewerPane = connect(mapStateToProps, mapDispatchToProps)(ViewerPaneView);
