import { createStore, compose } from 'redux';
import taskReducer from './reducers';
import { loadInputValues } from './actions/input';
import { resetMiddleware } from './middleware';
import { DOCUMENT_TYPES } from '../documents';
import { setScaleOptions } from './actions/ui';
import { initSolution } from './actions/solution';

export const store = compose(resetMiddleware())(createStore)(taskReducer);
export const dispatch = store.dispatch;

export const initStore = (input, facts = {}, presets = {}, scaleOptions) => {
    const { secret, document_types: documentTypes = DOCUMENT_TYPES, meta = {}, task_type: taskType } = input;

    dispatch(
        loadInputValues({
            secret,
            documentTypes,
            meta,
            facts,
            presets,
            taskType,
        }),
    );
    dispatch(setScaleOptions(scaleOptions));
    dispatch(initSolution({ documentTypes }));
};

export const resetStore = () => dispatch({ type: 'RESET' });
