import { getType } from 'typesafe-actions';
import * as actions from '../actions/documents';

const initialState = {
    documents: {},
};

const documentsReducer = (state = initialState, action) => {
    switch (action.type) {
        case getType(actions.setInitialDocumentsData):
            return {
                ...state,
                documents: {
                    ...state.documents,
                    ...action.payload,
                },
            };

        default:
            return state;
    }
};

export default documentsReducer;
