/* eslint-disable camelcase */
import { getType } from 'typesafe-actions';
import * as actions from '../actions/solution';

export const documentsFactory = (documentTypes, initialValues) =>
    Object.values(documentTypes).reduce((documents, document) => ({ ...documents, [document]: initialValues }), {});

const initialState = {
    verdicts: {},
    comments: {},
    extra: {},
};

const solutionReducer = (state = initialState, action) => {
    switch (action.type) {
        case getType(actions.initSolution):
            return {
                ...state,
                verdicts: documentsFactory(action.payload.documentTypes, []),
                comments: documentsFactory(action.payload.documentTypes, ''),
            };

        case getType(actions.setVerdictAndComment):
            return {
                ...state,
                verdicts: {
                    ...state.verdicts,
                    ...(action.payload.verdicts || {}),
                },
                comments: {
                    ...state.comments,
                    ...(action.payload.comments || {}),
                },
            };

        case getType(actions.setAdditionalFields):
            return {
                ...state,
                extra: {
                    ...state.extra,
                    [action.payload.documentType]: {
                        ...(state.extra[action.payload.documentType] || {}),
                        [action.payload.name]: action.payload.value,
                    },
                },
            };

        default:
            return state;
    }
};

export default solutionReducer;
