import { getType } from 'typesafe-actions';
import * as actions from '../actions/ui';
import { initErrorCounter, logError } from '../../../error-logger/errorLog';

const initialState = {
    activeDocumentIndex: 0,
    taskError: null,
    scaleOptions: {
        multipleSelect: false,
        otherWithComment: false,
        preferVideo: false,
    },
};

const uiReducer = (state = initialState, action) => {
    switch (action.type) {
        case getType(actions.setScaleOptions):
            return {
                ...state,
                scaleOptions: { ...action.payload },
            };

        case getType(actions.setActiveDocumentIndex):
            return {
                ...state,
                activeDocumentIndex: action.payload,
            };

        case getType(actions.setTaskError):
            if (action.payload) {
                initErrorCounter('');
                logError(
                    action.payload,
                    `Ошибка шаблона, статус ${action.payload.status ?? action.payload.data?.status}`
                );
            }

            return {
                ...state,
                taskError: action.payload,
            };

        default:
            return state;
    }
};

export default uiReducer;
