import '@yandex-int/error-counter/dist/interfaceWithoutRum';
import '@yandex-int/error-counter/dist/implementation';
import '@yandex-int/error-counter/dist/filters';
import '@yandex-int/error-counter/dist/sendWithoutRum';
import '@yandex-int/error-counter/dist/logError';
import '@yandex-int/error-counter/dist/logAjaxError';

// eslint-disable-next-line no-undef

export const getEnv = () => {
    const host = location.host.split(':')[0];

    switch (host) {
        case 'localhost':
            return 'development';
        default:
            return 'production';
    }
};

const generateErrorReqid = (secret) => +new Date() + '/' + secret;

export const initErrorCounter = (secret) => {
    window.Ya.Rum.initErrors({
        reqid: `${generateErrorReqid(secret)}`,
        project: 'DriveSBSYang',

        /* optional */
        env: getEnv(),
        debug: true,
        limits: {
            client: 1000
        },
        silent: {
            external: 3
        }
    });
};

export const logError = (error, source, info) => {
    if (window.Ya?.Rum?.logError) {

        window.Ya.Rum.logError(
            {
                additional: info,
                source,
                page: location.href,
            },
            error
        );
    }
};
