let serviceLocator = null;

class ServiceLocator {
    set validateAndCollect(callback) {
        this._validateAndCollect = callback;
    }

    get validateAndCollect() {
        return this._validateAndCollect;
    }

    get MediaREST() {
        return this._MediaREST;
    }

    get DataREST() {
        return this._DataREST;
    }

    get GeoREST() {
        return this._GeoREST;
    }

    constructor({ MediaREST, DataREST, GeoREST }) {
        this._MediaREST = MediaREST;
        this._DataREST = DataREST;
        this._GeoREST = GeoREST;
    }
}

function serviceLocatorFactory(settings, { replace = false } = {}) {
    if (serviceLocator !== null && replace !== true) {
        throw new Error('Service locator has already been created.');
    }
    serviceLocator = new ServiceLocator(settings);
    return serviceLocator;
}

export { serviceLocatorFactory, serviceLocator };
