import { isObject } from '../../utils/fn';
import { AbstractREST } from './AbstractREST';

export class StandaloneREST extends AbstractREST {
    constructor({ baseUrl, fetchFunction }) {
        super({ baseUrl });
        this._fetchFunction = fetchFunction;
    }

    _prepareBody(data) {
        if (data.body && isObject(data.body)) {
            data.body = JSON.stringify(data.body);
            data.headers = {
                ...data.headers,
                'Content-Type': 'application/json',
            };
        }

        return data;
    }

    _fetch(url, options) {
        return this._fetchFunction(this.createUrl(url), {
            credentials: 'include',
            ...this._prepareBody(options),
        })
            .then((res) => res.json())
            .catch((response) => Promise.reject(response));
    }

    async create(url, data) {
        return this._fetch(url, {
            method: 'POST',
            body: JSON.stringify(data),
        });
    }

    async read(url, options = {}) {
        return this._cachedFetch(url, options);
    }

    async update(url, data) {
        return this._fetch(url, {
            method: 'PUT',
            body: JSON.stringify(data),
        });
    }

    async delete(url) {
        return this._fetch(url, {
            method: 'DELETE',
        });
    }
}
