import { createElement } from 'react';
import { render, unmountComponentAtNode } from 'react-dom';
import { initStore, resetStore, store } from '../domain/store';
import { setTaskError } from '../domain/store/actions/documents';
import { serviceLocator } from '../infrastructure/serviceLocator';
import { TaskView } from '../components/TaskView';

export class TaskPageController {
    constructor({ element, input, facts, presets, scaleOptions }) {
        this.element = element;
        this.input = input;
        this.facts = facts;
        this.presets = presets;
        this.scaleOptions = scaleOptions;
    }

    get view() {
        return this._view;
    }

    createView() {
        this._view = render(createElement(TaskView), this.element);
    }

    getResults() {
        const { verdicts, comments: other, extra } = store.getState().solution;

        return {
            verdicts,
            other,
            extra,
        };
    }

    run() {
        initStore(this.input, this.facts, this.presets, this.scaleOptions);
        this.createView();
    }

    destroy() {
        if (this._view) {
            unmountComponentAtNode(this.element);
        }

        if (this.element.parentNode) {
            this.element.parentNode.removeChild(this.element);
        }

        resetStore();
    }

    showTaskError(message) {
        store.dispatch(setTaskError(message));
    }

    async validateAndCollect() {
        return serviceLocator.validateAndCollect();
    }
}
