import { stringify } from 'qs';
import { serviceLocator } from '../infrastructure/serviceLocator';

const MIN_QUERY_LENGTH = 3;

export const fetchAddressUsecase = async (query = '') => {
    if (query.length < MIN_QUERY_LENGTH) {
        return [];
    }

    const queryParams = stringify({ text: query, countries: 'RU' }, { addQueryPrefix: true });

    const results = await serviceLocator.GeoREST.read(`${queryParams}`);

    return Array.isArray(results) ? results : [];
};
