/* eslint-disable camelcase */
import { serviceLocator } from '../infrastructure/serviceLocator';
import { dispatch } from '../domain/store';
import { setInitialDocumentsData } from '../domain/store/actions/documents';
import { stringify } from 'qs';
import { DEFAULT_FIELDS_ORDER, DOCUMENT_TYPES } from '../domain/documents';
import { translate } from '../utils/translate';
import { sortObjectKeys } from '../utils/fn';

export const getDocumentsUsecase = async ({ secret, documentTypes, presets }) => {
    const hasInvalidPresets = documentTypes.some(
        (document) => !Object.values(DOCUMENT_TYPES).includes(document) && !Object.keys(presets).includes(document),
    );

    if (hasInvalidPresets) {
        throw new Error(translate('error_invalid_preset'));
    }

    const queryParams = stringify({ secretId: secret }, { addQueryPrefix: true });

    let documents = await serviceLocator.DataREST.read(`assignment/user_info${queryParams}`);

    // 1. strip unavailable document types
    documents = Object.entries(documents).reduce(
        (results, [document, values]) =>
            documentTypes.includes(document) ? { ...results, [document]: { ...values } } : results,
        {},
    );

    documents = Object.entries(documents).reduce(
        (results, [document, { data }]) => ({
            ...results,
            [document]: { data: { ...sortObjectKeys(data, DEFAULT_FIELDS_ORDER[document]) } },
        }),
        {},
    );

    dispatch(setInitialDocumentsData(documents));
};
