export const debounce = (callback, wait) => {
    let timeout;

    return (...args) => {
        // eslint-disable-next-line consistent-this
        const context = this;

        clearTimeout(timeout);
        timeout = setTimeout(() => callback.apply(context, args), wait);
    };
};
