const detectTolobrowserFeature = (iframeNode) => iframeNode.contentWindow === iframeNode.contentWindow.top;

// Во фреймах с атрибутом youshallnotpass переопределён window.top и равен window.top родительского сайта
// https://st.yandex-team.ru/BROWSER-63006
function isTolobrowser({ detectBrowser = detectTolobrowserFeature } = {}) {
    const tolobrowserFrame = document.createElement('iframe');

    tolobrowserFrame.setAttribute('youshallnotpass', '');
    tolobrowserFrame.style.display = 'none';

    document.body.appendChild(tolobrowserFrame);

    const isTolobrowser = detectBrowser(tolobrowserFrame);

    tolobrowserFrame.remove();

    return isTolobrowser;
}

export default isTolobrowser;
