exports.Task = extend(
    Drive.Task,
    function (options) {
        Drive.Task.call(this, options);
    },
    {},
);

exports.TaskSuite = extend(
    Drive.TaskSuite,
    function (options) {
        Drive.TaskSuite.call(this, options);
    },
    {
        getUserLocale: function () {
            return {
                en: {},
                ru: {},
            };
        },

        getProxyNames: function () {
            return {
                data: 'robot-yang-cars-registration-data',
                media: 'robot-yang-cars-registration',
                geo: 'robot-yang-cars-search-geo',
            };
        },

        getFacts: function () {
            return {
                passport_biographical: {
                    NOT_DOCUMENT: 'Нет документа',
                    FOREIGN: 'Иностранный документ',
                    WRONG_DOC: 'Не тот документ',
                    FAKE: 'Подделка',
                    NOT_ORIGIN: 'Не оригинал',
                    BAD_DOC: 'Перефото не поможет',
                    BAD_PHOTO: 'Перефото поможет',
                },
                passport_registration: {
                    VIDEO_ERROR: 'Ошибка видео',
                    STRANGER_HANDS: 'Помощь в съемке: Чужие руки',
                    NO_OBJECT: 'Нет документа',
                    NOT_ORIGINAL: 'Не оригинал документа',
                    CONSTRUCTION_SITE: 'Стройка на фоне',
                    HOSTEL_SITE: 'Общежитие на фоне',
                },
                passport_selfie: {
                    VIDEO_ERROR: 'Ошибка видео',
                    ASSISTED_SELFIE: 'Помощь в съемке: Делает селфи не сам',
                    STRANGER_HANDS: 'Помощь в съемке: Чужие руки',
                    NO_OBJECT: 'Нет документа и/или человека',
                    NOT_ORIGINAL: 'Не оригинал документа',
                    SCREENCAP_SELFIE: 'Экранка селфи',
                    UNCONSCIOUS_SELFIE: 'Человек не осознаёт, что делает',
                    CONSTRUCTION_SITE: 'Стройка на фоне',
                    HOSTEL_SITE: 'Общежитие на фоне',
            },
                license_front: {
                    VIDEO_ERROR: 'Ошибка видео',
                    STRANGER_HANDS: 'Помощь в съемке: Чужие руки',
                    NO_OBJECT: 'Нет документа',
                    NOT_ORIGINAL: 'Не оригинал документа',
                    CONSTRUCTION_SITE: 'Стройка на фоне',
                    HOSTEL_SITE: 'Общежитие на фоне',
                },
                license_back: {
                    VIDEO_ERROR: 'Ошибка видео',
                    STRANGER_HANDS: 'Помощь в съемке: Чужие руки',
                    NO_OBJECT: 'Нет документа',
                    NOT_ORIGINAL: 'Не оригинал документа',
                    CONSTRUCTION_SITE: 'Стройка на фоне',
                    HOSTEL_SITE: 'Общежитие на фоне',
                },
                license_selfie: {
                    VIDEO_ERROR: 'Ошибка видео',
                    STRANGER_HANDS: 'Помощь в съемке: Чужие руки',
                    NO_OBJECT: 'Нет документа',
                    NOT_ORIGINAL: 'Не оригинал документа',
                    CONSTRUCTION_SITE: 'Стройка на фоне',
                    HOSTEL_SITE: 'Общежитие на фоне',
                },
                selfie: {
                    VIDEO_ERROR: 'Ошибка видео',
                    STRANGER_HANDS: 'Помощь в съемке: Чужие руки',
                    NO_OBJECT: 'Нет документа',
                    NOT_ORIGINAL: 'Не оригинал документа',
                    CONSTRUCTION_SITE: 'Стройка на фоне',
                    HOSTEL_SITE: 'Общежитие на фоне',
                },
                documents_compare: {
                    NO_MATCH: 'Нет соответствия',
                    FAKE: 'Подделка',
                    NOT_ORIGINAL: 'Не оригинал',
                    DIFFERENT_SAMPLES: 'Разные образцы',
                    IMPOSSIBLE_TO_VERIFY: 'Невозможно сверить',
                    UNEQUAL_DATA: 'Данные не совпадают',
                    HOSTEL_SITE: 'Общежитие на фоне',
                },
                face_compare: {
                    LOW_QUALITY_PASSPORT_BIOGRAPHICAL: 'Недостаточное качество фото в блоке "Паспорт: Лицевая"',
                    LOW_QUALITY_SELFIE: 'Недостаточное качество фото в блоке "Селфи"',
                    LOW_QUALITY_LICENSE_FRONT: 'Недостаточное качество фото в блоке "Права: Лицевая"',
                    ANOTHER_PERSON: 'Другой человек',
                    NOT_ORIGINAL: 'Не оригинал документа',
                    SCREENCAP_SELFIE: 'Экранка селфи',
                    WRONG_DOC: 'Не тот документ',
                    SHOW_SUPPORTS: 'Показать саппортам',
                },
            };
        },

        getPresets: function() {
            return {
                documents_compare: {
                    document_types: ['license_front', 'license_back'],
                    is_video_available: true,
                },
                face_compare: {
                    document_types: ['passport_selfie', 'license_selfie', 'selfie'],
                    is_video_available: false,
                },
            }
        },

        getScaleOptions: function () {
            return {
                multipleSelect: false,
                otherWithComment: true,
                preferVideo: false,
                specialHeaders: {
                    passport_selfie: 'Проверка на адекватность',
                    documents_compare: 'Сверка документов',
                    face_compare: 'Сверка лиц',
                },
                additionalFields: {
                    type_document: {
                        type: 'dropdown',
                        label: 'Тип документа',
                        required: true,
                        values:
                            {
                                REGISTRATION: 'Регистрация в паспорте',
                                MIGRACION: 'Миграционная карта',
                                NO_OBJECT: 'Не применимо'
                            }
                    },
                    verdict: {
                        type: 'dropdown',
                        label: 'Причина отказа',
                        required: false,
                        values:
                            {
                                NEED_ADRESS: 'Нужен адрес',
                                NEEN_SIG: 'Нужна подпись',
                                NO_OBJECT: 'Не применимо'
                            }
                    }
                }
            };
        },
    },
);

function extend(ParentClass, constructorFunction, prototypeHash) {
    constructorFunction = constructorFunction || function () {};
    prototypeHash = prototypeHash || {};
    if (ParentClass) {
        constructorFunction.prototype = Object.create(ParentClass.prototype);
    }
    for (var i in prototypeHash) {
        constructorFunction.prototype[i] = prototypeHash[i];
    }
    return constructorFunction;
}
