const path = require('path');
const fs = require('fs');

const getRandom = (min, max) => Math.floor(Math.random() * (max - min + 1) + min);

const pictureDimensionsFactory = () => {
    const knownDocuments = [
        'passport_biographical',
        'passport_registration',
        'passport_selfie',
        'license_front',
        'license_back',
        'license_selfie',
        'selfie',
    ];

    return knownDocuments.reduce(
        (results, documentType) => ({
            ...results,
            ...{ [documentType]: { width: getRandom(500, 1000), height: getRandom(500, 1000) } },
        }),
        {},
    );
};

const pictureDimensions = pictureDimensionsFactory();

module.exports = {
    certPath: path.resolve(__dirname, './ssl/dev.pem'),
    project: {
        title: 'Drive: video/picture sbs',
        description: 'Toloka template for Drive users video/pictures SBS',
        instructions: 'TBD',
        hideSkip: true,
        markup: path.resolve(process.cwd(), './static/markup.hbs'),
        styles: path.resolve(process.cwd(), './static/styles.css'),
        script: path.resolve(process.cwd(), './static/script.js'),
        scriptUrls: ['https://local.yang.yandex-team.ru:3002/template-drive-custom-sbs.js'],
        tasks: [
            {
                id: 0,
                input_values: {
                    secret: '12345',
                    document_types: [
                        'passport_biographical',
                        'passport_registration',
                        'license_front',
                        'license_back',
                        'passport_selfie',
                        'documents_compare',
                        'face_compare',
                    ],
                    task_type: 'reissue_license',
                    user_id: 'b9eb0604-7594-4a11-98c0-0279b6432cc8',
                    meta: {
                        comment:
                            '# This is Markdown\n\n####\n\n[Markdown](http://daringfireball.net/projects/markdown/) lets you write content in a really natural way.\n\n* You can have lists, like this one\n* Make things **bold** or *italic*\n* Embed snippets of `code`\nCreate [links](/)\n\n<small>Sample content borrowed with thanks from [elm-markdown](http://elm-lang.org/examples/markdown) ❤️</small>',
                    },
                },
            },
        ],
        outputSpec: {
            verdicts: {
                type: 'json',
                required: true,
                hidden: false,
            },
            other: {
                type: 'json',
                required: false,
                hidden: false,
            },
            extra: {
                type: 'json',
                required: false,
                hidden: false,
            },
        },
        middleware: {
            before: [
                {
                    path: new RegExp('^/api/proxy/robot-yang-cars-registration-data/assignment/document_data?(.+)'),
                    handler: (req, res, next) => {
                        const documentType = req.query?.photo_type;

                        if (documentType.match(/(.+)_video/)) {
                            const filePath = path.resolve(__dirname, `./mocks/small.mp4`);

                            res.header('Cache-Control', 'private, no-cache, no-store, must-revalidate');
                            res.header('Expires', '-1');
                            res.header('Pragma', 'no-cache');

                            return fs.existsSync(filePath) ? res.end(fs.readFileSync(filePath)) : next();
                        }

                        if (!pictureDimensions[documentType]) {
                            return next();
                        }

                        const { width, height } = pictureDimensions[documentType];

                        return res.redirect(`https://placekitten.com/${width}/${height}`);
                    },
                },
                {
                    path: new RegExp('^/api/proxy/robot-yang-cars-registration-data/assignment/user_info?(.+)'),
                    method: 'get',
                    handler: (req, res, next) => {
                        const filePath = path.resolve(__dirname, './mocks/documents.json');

                        return fs.existsSync(filePath) ? res.json(require(filePath)) : next();
                    },
                },
                {
                    path: new RegExp('^/api/proxy/robot-yang-cars-registration-data/assignment/user_info?(.+)'),
                    method: 'post',
                    handler: (req, res, next) => {
                        res.writeHead(200, {
                            foo: 'bar',
                        });
                        return res.end();
                    },
                },
                {
                    path: new RegExp('^/api/proxy/robot-yang-cars-search-geo/'),
                    handler: (req, res, next) => {
                        const filePath = path.resolve(__dirname, `./mocks/address.json`);

                        return fs.existsSync(filePath) ? res.json(require(filePath)) : next();
                    },
                },
            ],
        },
    },
};
