import defaultTranslations from './i18n.json';
import tanker from './tanker/all.json';

const supportedLanguages = ['ru', 'en'];
const KEYSET_NAME = 'main';
const pluralMappings = {
    ru: ['', '_plural_2', '_plural_5'],
    en: ['', '_plural'],
};

function parseTankerValue(key, values, lng) {
    if (!Array.isArray(values)) {
        return {
            [key]: values,
        };
    }

    return values.reduce(
        (result, value, index) => ({
            ...result,
            [key + pluralMappings[lng][index]]: value,
        }),
        {},
    );
}

function parseTankerKeysets(keysets, lng) {
    const mainKeys = keysets[KEYSET_NAME] || {};

    return Object.keys(mainKeys).reduce(
        (result, key) => ({
            ...result,
            ...parseTankerValue(key, mainKeys[key], lng),
        }),
        {},
    );
}

export const createTranslationKeys = (additionalTranslations) =>
    supportedLanguages.reduce((result, lng) => {
        result[lng] = {
            translation: {
                ...defaultTranslations[lng],
                ...parseTankerKeysets(tanker[lng], lng),
                ...additionalTranslations[lng],
            },
        };
        return result;
    }, {});
