import React, { useState } from 'react';
import { useTranslation } from 'react-i18next';
import { Form, Select } from 'antd';
import { COUNTRIES, EXTRA_COUNTRIES } from '../../../domain/countries';
import { translate } from '../../../utils/translate';
import { Hint } from '../../Utility/Hint';

export const CountryPicker = () => {
    const [countries, setCountries] = useState([...COUNTRIES, ...EXTRA_COUNTRIES]);
    const [, i18next] = useTranslation();

    const renderCountry = ({ ru, en, value, altValue }) => (
        <Select.Option key={value.toUpperCase()} value={altValue.toUpperCase()}>
            {i18next.language === 'ru' ? ru.toUpperCase() : en.toUpperCase()}
        </Select.Option>
    );

    const handleCountrySearch = (query) => {
        setCountries([
            ...[...COUNTRIES].filter((country) =>
                Object.values(country).some(
                    (value) => typeof value === 'string' && value.toLowerCase().startsWith(query.toLowerCase()),
                ),
            ),
            ...EXTRA_COUNTRIES,
        ]);
    };

    return (
        <Hint title={translate('document_country_hint')} placement="left">
            <Form.Item
                name="country"
                label={translate('document_country')}
                rules={[
                    {
                        required: true,
                        message: translate('error_field_required'),
                    },
                ]}
            >
                <Select
                    showSearch
                    placeholder={translate('document_country_placeholder')}
                    filterOption={false}
                    onSearch={handleCountrySearch}
                >
                    {countries.map(renderCountry)}
                </Select>
            </Form.Item>
        </Hint>
    );
};
