import React from 'react';
import PropTypes from 'prop-types';
import { Form } from 'antd';
import { Hint } from '../../Utility/Hint';
import './Presenter.less';

export const PresenterField = ({ hint, label, children, ...restProps }) => {
    const item = (
        <Form.Item className="presenter" label={label} {...restProps}>
            {children}
        </Form.Item>
    );

    return hint ? (
        <Hint title={hint} placement="topLeft">
            {item}
        </Hint>
    ) : (
        item
    );
};

PresenterField.propTypes = {
    label: PropTypes.node.isRequired,
    hint: PropTypes.string,
};
