import React from 'react';
import PropTypes from 'prop-types';
import MaskedInput from 'antd-mask-input';
import { Form, Input } from 'antd';
import { translate } from '../../../utils/translate';
import { Hint } from '../../Utility/Hint';

const InputComponent = ({ mask, ...restProps }) =>
    mask ? <MaskedInput mask={mask} {...restProps} /> : <Input {...restProps} />;

export const TextField = ({
    addonBefore,
    hint,
    mask,
    name,
    pattern,
    placeholder,
    required = false,
    tabIndex,
    extraRules = [],
    ...restProps
}) => {
    const rules = [
        {
            required,
            message: translate('error_field_value_required'),
        },
    ];

    if (pattern) {
        rules.push({
            pattern,
            message: translate('error_wrong_format'),
        });
    }

    const item = (
        <Form.Item
            label={translate(`field_${name}`)}
            name={name}
            preserve={false}
            rules={[...rules, ...extraRules]}
            {...restProps}
        >
            <InputComponent
                allowClear
                mask={mask}
                placeholder={placeholder}
                tabIndex={tabIndex}
                addonBefore={addonBefore}
            />
        </Form.Item>
    );

    return hint ? <Hint title={hint}>{item}</Hint> : item;
};

InputComponent.propTypes = {
    mask: PropTypes.string,
};

TextField.propTypes = {
    name: PropTypes.string.isRequired,
    placeholder: PropTypes.string,
    hint: PropTypes.string,
    addonBefore: PropTypes.node,
    tabIndex: PropTypes.number,
    required: PropTypes.bool,
    pattern: PropTypes.instanceOf(RegExp),
    mask: PropTypes.string,
    extraRules: PropTypes.arrayOf(
        PropTypes.shape({
            required: PropTypes.bool,
            enum: PropTypes.arrayOf(PropTypes.any),
            len: PropTypes.number,
            max: PropTypes.number,
            min: PropTypes.number,
            message: PropTypes.string,
            pattern: PropTypes.instanceOf(RegExp),
            transform: PropTypes.func,
            validator: PropTypes.func,
            validateTrigger: PropTypes.oneOf([PropTypes.string, PropTypes.arrayOf(PropTypes.string.isRequired)]),
            range: PropTypes.shape({
                from: PropTypes.any,
                to: PropTypes.any,
            }),
            type: PropTypes.oneOf([
                'string',
                'number',
                'boolean',
                'url',
                'email',
                'method',
                'regexp',
                'integer',
                'float',
                'array',
                'object',
                'enum',
                'date',
                'hex',
                'any',
            ]),
        }),
    ),
};
